#include "StdAfx.h"
#include "FileRenderer.h"

BOOL on_process_live_video_frame_buffer( ULONG nChannelNumber, double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	ULONG i = nChannelNumber - 1;

	CFileRenderer * pFileRenderer = (CFileRenderer *)(pUserData);

	if ( pFileRenderer->m_bIsRecording == FALSE ) return FALSE;

	DEVICE_HANDLE hVideoEncoderDev = pFileRenderer->m_hVideoSwEncoderDev;

	DEVICE_HANDLE hFileRendererDev = pFileRenderer->m_hMainFileRendererDev;

	BOOL bIsRecord = (pFileRenderer->m_nMainFileRendererRecordState >= 0x00000002) ? TRUE : FALSE;

	if ( hVideoEncoderDev != 0xFFFFFFFF && hFileRendererDev != 0xFFFFFFFF )
	{
		BYTE * pStreamBuffer = NULL;

		ULONG  nStreamBufferLen = 0;

		BOOL   bIsKeyFrame = FALSE;

		AMESDK_RUN( hVideoEncoderDev ); // PUT THE ENCODER INTO RUNNING STATE

		AMESDK_CODEC_ENCODE( hVideoEncoderDev, pBuffer, pFileRenderer->m_nVideoColorSapce, pFileRenderer->m_nMainFrameWidth, pFileRenderer->m_nMainFrameHeight, &pStreamBuffer, &nStreamBufferLen, &bIsKeyFrame );

		if( bIsKeyFrame ) 
		{ 
			pFileRenderer->m_nMainFileRendererRecordState = 0x00000002;

			bIsRecord = TRUE;
		}

		if( bIsRecord ) 
		{
			ULONGLONG nSampleTime = (ULONGLONG)(dSampleTime * 10000000);

			AMESDK_FILE_SET_VIDEO_STREAM_BUFFER( hFileRendererDev, pStreamBuffer, nStreamBufferLen, bIsKeyFrame, 0, nSampleTime );
		}
	}

	return TRUE;
}

BOOL on_process_live_audio_frame_buffer_ex( ULONG nChannelNumber, double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	ULONG				i = nChannelNumber - 1;

	CFileRenderer * pFileRenderer = (CFileRenderer *)(pUserData);	

	if ( pFileRenderer->m_bIsRecording == FALSE ) return FALSE;

	DEVICE_HANDLE hAudioDev = pFileRenderer->m_hAudioDev;

	DEVICE_HANDLE hAudioSwEncoderDev = pFileRenderer->m_hAudioSwEncoderDev;

	DEVICE_HANDLE hMainFileRendererDev = pFileRenderer->m_hMainFileRendererDev;

	DEVICE_HANDLE hSubFileRendererDev = pFileRenderer->m_hSubFileRendererDev;

	ULONG nAudioEncoderType = pFileRenderer->m_nAudioEncoderType;

	BOOL bIsRecord1 = ( pFileRenderer->m_nMainFileRendererRecordState >= 0x00000002) ? TRUE : FALSE;

	BOOL bIsRecord2 = ( pFileRenderer->m_nSubFileRendererRecordState >= 0x00000002) ? TRUE : FALSE;

	if ( hAudioDev != 0xFFFFFFFF && hMainFileRendererDev != 0xFFFFFFFF )
	{
		if ( nAudioEncoderType == AUDIO_FORMAT_PCM )
		{
			if( bIsRecord1 ) 
			{
				ULONGLONG nSampleTime = (ULONGLONG)(dSampleTime * 10000000);

				//EnterCriticalSection( &pFileRenderer->m_hMainFileRendererChangeCriticalSection);			

				AMESDK_FILE_SET_AUDIO_STREAM_BUFFER( hMainFileRendererDev, pBuffer, nBufferLen, 0, nSampleTime );

				//LeaveCriticalSection( &pFileRenderer->m_hMainFileRendererChangeCriticalSection );
			}			
		}

		if ( ( nAudioEncoderType == AUDIO_FORMAT_AAC || nAudioEncoderType == AUDIO_FORMAT_AAC_ADTS || nAudioEncoderType == AUDIO_FORMAT_MP2 || nAudioEncoderType == AUDIO_FORMAT_MP3 || nAudioEncoderType == AUDIO_FORMAT_OPUS ) && 

			( hAudioSwEncoderDev !=  0xFFFFFFFF ) )
		{
			if( bIsRecord1 ) 
			{
				ULONGLONG n_src_sample_time = (ULONGLONG)(dSampleTime * 10000000);

				ULONGLONG n_dst_sample_time = 0;

				BYTE * pStreamBuffer = NULL;

				ULONG  nStreamBufferSize = 0;

				AMESDK_CODEC_ENCODE( hAudioSwEncoderDev, pBuffer, nBufferLen, &pStreamBuffer, &nStreamBufferSize, n_src_sample_time, &n_dst_sample_time );

				if( pStreamBuffer != NULL && nStreamBufferSize > 0 )
				{
					//EnterCriticalSection( &pFileRenderer->m_hMainFileRendererChangeCriticalSection);

					AMESDK_FILE_SET_AUDIO_STREAM_BUFFER( hMainFileRendererDev, pStreamBuffer, nStreamBufferSize, 0, n_dst_sample_time );					

					//LeaveCriticalSection( &pFileRenderer->m_hMainFileRendererChangeCriticalSection );
				}			
			}			
		}
	}

	/*
	if ( hAudioDev != 0xFFFFFFFF && hSubFileRendererDev != 0xFFFFFFFF )
	{
		if ( nAudioEncoderType == AUDIO_FORMAT_PCM )
		{
			EnterCriticalSection( &pFileRenderer->m_hSubFileRendererChangeCriticalSection);			

			if( bIsRecord2 ) 
			{
				ULONGLONG nSampleTime = (ULONGLONG)(dSampleTime * 10000000);

				AMESDK_FILE_SET_AUDIO_STREAM_BUFFER( hSubFileRendererDev, pBuffer, nBufferLen, 0, nSampleTime );
			}

			LeaveCriticalSection( &pFileRenderer->m_hSubFileRendererChangeCriticalSection );
		}

		if ( ( nAudioEncoderType == AUDIO_FORMAT_AAC || nAudioEncoderType == AUDIO_FORMAT_AAC_ADTS || nAudioEncoderType == AUDIO_FORMAT_MP2 || nAudioEncoderType == AUDIO_FORMAT_MP3 || nAudioEncoderType == AUDIO_FORMAT_OPUS ) && 

			( hAudioSwEncoderDev !=  0xFFFFFFFF ) )
		{
			if( bIsRecord2 ) 
			{
				ULONGLONG n_src_sample_time = (ULONGLONG)(dSampleTime * 10000000);

				ULONGLONG n_dst_sample_time = 0;

				BYTE * pStreamBuffer = NULL;

				ULONG  nStreamBufferSize = 0;

				AMESDK_CODEC_ENCODE( hAudioSwEncoderDev, pBuffer, nBufferLen, &pStreamBuffer, &nStreamBufferSize, n_src_sample_time, &n_dst_sample_time );

				if( pStreamBuffer != NULL && nStreamBufferSize > 0 )
				{
					EnterCriticalSection( &pFileRenderer->m_hSubFileRendererChangeCriticalSection);

					AMESDK_FILE_SET_AUDIO_STREAM_BUFFER( hSubFileRendererDev, pStreamBuffer, nStreamBufferSize, 0, n_dst_sample_time );

					LeaveCriticalSection( &pFileRenderer->m_hSubFileRendererChangeCriticalSection );
				}			
			}			
		}
	}
	*/

	return TRUE;
}

BOOL on_process_live_audio_frame_buffer( ULONG nChannelNumber, double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	ULONG				i = nChannelNumber - 1;

	CFileRenderer * pFileRenderer = (CFileRenderer *)(pUserData);

	if ( pFileRenderer->m_bIsRecording == FALSE ) return FALSE;

	if (  pFileRenderer->m_strChipName == "FH8735 PCI" || pFileRenderer->m_strChipName == "QP0203 PCI"  || pFileRenderer->m_strChipName == "MZ0380 PCI" || pFileRenderer->m_strChipName == "TW2809 PCI"  )
	{
		BOOL returns = on_process_live_audio_frame_buffer_ex( nChannelNumber, dSampleTime, pBuffer, (nBufferLen >> 1), bIsKeyFrame, pUserData );

		double ts = (nBufferLen >> 1);

		ts /= 192000;

		returns = on_process_live_audio_frame_buffer_ex( nChannelNumber, dSampleTime + ts, pBuffer + (nBufferLen >> 1), (nBufferLen >> 1), bIsKeyFrame, pUserData );

		return returns;
	}

	DEVICE_HANDLE hAudioDev = pFileRenderer->m_hAudioDev;

	DEVICE_HANDLE hAudioSwEncoderDev = pFileRenderer->m_hAudioSwEncoderDev;

	DEVICE_HANDLE hMainFileRendererDev = pFileRenderer->m_hMainFileRendererDev;

	DEVICE_HANDLE hSubFileRendererDev = pFileRenderer->m_hSubFileRendererDev;

	ULONG nAudioEncoderType = pFileRenderer->m_nAudioEncoderType;

	BOOL bIsRecord1 = ( pFileRenderer->m_nMainFileRendererRecordState >= 0x00000002) ? TRUE : FALSE;

	BOOL bIsRecord2 = ( pFileRenderer->m_nSubFileRendererRecordState >= 0x00000002) ? TRUE : FALSE;

	if ( hAudioDev != 0xFFFFFFFF && hMainFileRendererDev != 0xFFFFFFFF )
	{
		if ( nAudioEncoderType == AUDIO_FORMAT_PCM )
		{
			EnterCriticalSection( &pFileRenderer->m_hMainFileRendererChangeCriticalSection);			

			if( bIsRecord1 ) 
			{
				ULONGLONG nSampleTime = (ULONGLONG)(dSampleTime * 10000000);

				AMESDK_FILE_SET_AUDIO_STREAM_BUFFER( pFileRenderer->m_hMainFileRendererDev, pBuffer, nBufferLen, 0, nSampleTime );
			}

			LeaveCriticalSection( &pFileRenderer->m_hMainFileRendererChangeCriticalSection );
		}

		if ( ( nAudioEncoderType == AUDIO_FORMAT_AAC || nAudioEncoderType == AUDIO_FORMAT_AAC_ADTS || nAudioEncoderType == AUDIO_FORMAT_MP2 || nAudioEncoderType == AUDIO_FORMAT_MP3 || nAudioEncoderType == AUDIO_FORMAT_OPUS ) && 

			( hAudioSwEncoderDev !=  0xFFFFFFFF ) )
		{
			if( bIsRecord1 ) 
			{
				ULONGLONG n_src_sample_time = (ULONGLONG)(dSampleTime * 10000000);

				ULONGLONG n_dst_sample_time = 0;

				BYTE * pStreamBuffer = NULL;

				ULONG  nStreamBufferSize = 0;				

				AMESDK_CODEC_ENCODE( hAudioSwEncoderDev, pBuffer, nBufferLen, &pStreamBuffer, &nStreamBufferSize, n_src_sample_time, &n_dst_sample_time );

				if( pStreamBuffer != NULL && nStreamBufferSize > 0 )
				{
					EnterCriticalSection( &pFileRenderer->m_hMainFileRendererChangeCriticalSection);					

					AMESDK_FILE_SET_AUDIO_STREAM_BUFFER( hMainFileRendererDev, pStreamBuffer, nStreamBufferSize, 0, n_dst_sample_time );

					LeaveCriticalSection( &pFileRenderer->m_hMainFileRendererChangeCriticalSection );
				}			
			}			
		}
	}

	/*
	if ( hAudioDev != 0xFFFFFFFF && hSubFileRendererDev != 0xFFFFFFFF )
	{
		if ( nAudioEncoderType == AUDIO_FORMAT_PCM )
		{
			EnterCriticalSection( &pFileRenderer->m_hSubFileRendererChangeCriticalSection);			

			if( bIsRecord2 ) 
			{
				ULONGLONG nSampleTime = (ULONGLONG)(dSampleTime * 10000000);

				AMESDK_FILE_SET_AUDIO_STREAM_BUFFER( hSubFileRendererDev, pBuffer, nBufferLen, 0, nSampleTime );
			}

			LeaveCriticalSection( &pFileRenderer->m_hSubFileRendererChangeCriticalSection );
		}

		if ( ( nAudioEncoderType == AUDIO_FORMAT_AAC || nAudioEncoderType == AUDIO_FORMAT_AAC_ADTS || nAudioEncoderType == AUDIO_FORMAT_MP2 || nAudioEncoderType == AUDIO_FORMAT_MP3 || nAudioEncoderType == AUDIO_FORMAT_OPUS ) && 

			( hAudioSwEncoderDev !=  0xFFFFFFFF ) )
		{
			if( bIsRecord2 ) 
			{
				ULONGLONG n_src_sample_time = (ULONGLONG)(dSampleTime * 10000000);

				ULONGLONG n_dst_sample_time = 0;

				BYTE * pStreamBuffer = NULL;

				ULONG  nStreamBufferSize = 0;

				AMESDK_CODEC_ENCODE( hAudioSwEncoderDev, pBuffer, nBufferLen, &pStreamBuffer, &nStreamBufferSize, n_src_sample_time, &n_dst_sample_time );

				if( pStreamBuffer != NULL && nStreamBufferSize > 0 )
				{
					EnterCriticalSection( &pFileRenderer->m_hSubFileRendererChangeCriticalSection);					

					AMESDK_FILE_SET_AUDIO_STREAM_BUFFER( hSubFileRendererDev, pStreamBuffer, nStreamBufferSize, 0, n_dst_sample_time );

					LeaveCriticalSection( &pFileRenderer->m_hSubFileRendererChangeCriticalSection );
				}			
			}			
		}
	}
	*/

	return TRUE;
}

BOOL on_process_video_main_encoder_buffer( ULONG nChannelNumber, double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	ULONG i = nChannelNumber - 1;

	CFileRenderer * pFileRenderer = (CFileRenderer *)(pUserData);

	if ( pFileRenderer->m_bIsRecording == FALSE ) return FALSE;

	DEVICE_HANDLE m_hVideoMainEncoderDev = pFileRenderer->m_hVideoMainEncoderDev;

	DEVICE_HANDLE hFileRendererDev = pFileRenderer->m_hMainFileRendererDev;

	BOOL bIsRecord = (pFileRenderer->m_nMainFileRendererRecordState >= 0x00000002) ? TRUE : FALSE;

	if ( m_hVideoMainEncoderDev != 0xFFFFFFFF && hFileRendererDev != 0xFFFFFFFF )
	{
		if( pFileRenderer->m_nMainFileRendererRecordState == 0x00000001 ) { // WAITING KEY FRAME

			pFileRenderer->m_nMainFileRendererRecordState = 0x00000002; // TO GOTO START STATE

			bIsRecord = TRUE;
		}	

		if ( bIsRecord )
		{
			ULONGLONG nSampleTime = (ULONGLONG)(dSampleTime * 10000000);

			EnterCriticalSection( &pFileRenderer->m_hMainFileRendererChangeCriticalSection );

			AMESDK_FILE_SET_VIDEO_STREAM_BUFFER( hFileRendererDev, pBuffer, nBufferLen, bIsKeyFrame, 0, nSampleTime );

			LeaveCriticalSection( &pFileRenderer->m_hMainFileRendererChangeCriticalSection );
		}
	}

	return TRUE;
}

BOOL on_process_video_sub_encoder_buffer( ULONG nChannelNumber, double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	ULONG i = nChannelNumber - 1;

	CFileRenderer * pFileRenderer = (CFileRenderer *)(pUserData);

	if ( pFileRenderer->m_bIsRecording == FALSE ) return FALSE;

	DEVICE_HANDLE m_hVideoSubEncoderDev = pFileRenderer->m_hVideoSubEncoderDev;

	DEVICE_HANDLE hFileRendererDev = pFileRenderer->m_hSubFileRendererDev;

	BOOL bIsRecord = (pFileRenderer->m_nSubFileRendererRecordState >= 0x00000002) ? TRUE : FALSE;

	if ( m_hVideoSubEncoderDev != 0xFFFFFFFF && hFileRendererDev != 0xFFFFFFFF )
	{
		if( pFileRenderer->m_nSubFileRendererRecordState == 0x00000001 ) { // WAITING KEY FRAME

			pFileRenderer->m_nSubFileRendererRecordState = 0x00000002; // TO GOTO START STATE

			bIsRecord = TRUE;
		}	

		if ( bIsRecord )
		{
			ULONGLONG nSampleTime = (ULONGLONG)(dSampleTime * 10000000);

			EnterCriticalSection( &pFileRenderer->m_hSubFileRendererChangeCriticalSection );

			AMESDK_FILE_SET_VIDEO_STREAM_BUFFER( hFileRendererDev, pBuffer, nBufferLen, bIsKeyFrame, 0, nSampleTime );

			LeaveCriticalSection( &pFileRenderer->m_hSubFileRendererChangeCriticalSection );
		}
	}

	return TRUE;
}

BOOL on_process_live_video_frame_buffer_CH01( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer( 1, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH02( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer( 2, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH03( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer( 3, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH04( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer( 4, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH05( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer( 5, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH06( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer( 6, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH07( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer( 7, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH08( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer( 8, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_live_video_frame_buffer_CH09( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer(  9, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH10( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer( 10, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH11( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer( 11, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH12( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer( 12, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH13( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer( 13, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH14( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer( 14, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH15( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer( 15, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH16( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer( 16, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

PF_BUFFER_CALLBACK g_on_live_video_callback[ 16 ] = 
{  
	on_process_live_video_frame_buffer_CH01, on_process_live_video_frame_buffer_CH02, on_process_live_video_frame_buffer_CH03, on_process_live_video_frame_buffer_CH04, 
	on_process_live_video_frame_buffer_CH05, on_process_live_video_frame_buffer_CH06, on_process_live_video_frame_buffer_CH07, on_process_live_video_frame_buffer_CH08, 
	on_process_live_video_frame_buffer_CH09, on_process_live_video_frame_buffer_CH10,	on_process_live_video_frame_buffer_CH11, on_process_live_video_frame_buffer_CH12, 
	on_process_live_video_frame_buffer_CH13, on_process_live_video_frame_buffer_CH14, on_process_live_video_frame_buffer_CH15,  on_process_live_video_frame_buffer_CH16,
};

BOOL on_process_live_audio_frame_buffer_CH01( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_audio_frame_buffer( 1, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_audio_frame_buffer_CH02( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_audio_frame_buffer( 2, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_audio_frame_buffer_CH03( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_audio_frame_buffer( 3, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_audio_frame_buffer_CH04( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_audio_frame_buffer( 4, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_audio_frame_buffer_CH05( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_audio_frame_buffer( 5, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_audio_frame_buffer_CH06( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_audio_frame_buffer( 6, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_audio_frame_buffer_CH07( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_audio_frame_buffer( 7, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_audio_frame_buffer_CH08( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_audio_frame_buffer( 8, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_audio_frame_buffer_CH09( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_audio_frame_buffer( 9, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_audio_frame_buffer_CH10( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_audio_frame_buffer( 10, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_audio_frame_buffer_CH11( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_audio_frame_buffer( 11, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_audio_frame_buffer_CH12( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_audio_frame_buffer( 12, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_audio_frame_buffer_CH13( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_audio_frame_buffer( 13, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_audio_frame_buffer_CH14( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_audio_frame_buffer( 14, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_audio_frame_buffer_CH15( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_audio_frame_buffer( 15, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_audio_frame_buffer_CH16( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_audio_frame_buffer( 16, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

PF_BUFFER_CALLBACK g_on_live_audio_callback[ 16 ] = 
{ 
    on_process_live_audio_frame_buffer_CH01, on_process_live_audio_frame_buffer_CH02, on_process_live_audio_frame_buffer_CH03, on_process_live_audio_frame_buffer_CH04,
	on_process_live_audio_frame_buffer_CH05, on_process_live_audio_frame_buffer_CH06, on_process_live_audio_frame_buffer_CH07, on_process_live_audio_frame_buffer_CH08,
	on_process_live_audio_frame_buffer_CH09, on_process_live_audio_frame_buffer_CH10, on_process_live_audio_frame_buffer_CH11, on_process_live_audio_frame_buffer_CH12,
	on_process_live_audio_frame_buffer_CH13, on_process_live_audio_frame_buffer_CH14, on_process_live_audio_frame_buffer_CH15, on_process_live_audio_frame_buffer_CH16
};

BOOL on_process_video_main_encoder_buffer_CH01( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_main_encoder_buffer( 1, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_video_main_encoder_buffer_CH02( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_main_encoder_buffer( 2, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_video_main_encoder_buffer_CH03( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_main_encoder_buffer( 3, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_video_main_encoder_buffer_CH04( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_main_encoder_buffer( 4, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_video_main_encoder_buffer_CH05( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_main_encoder_buffer( 5, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_video_main_encoder_buffer_CH06( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_main_encoder_buffer( 6, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_video_main_encoder_buffer_CH07( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_main_encoder_buffer( 7, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_video_main_encoder_buffer_CH08( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_main_encoder_buffer( 8, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_video_main_encoder_buffer_CH09( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_main_encoder_buffer(  9, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_video_main_encoder_buffer_CH10( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_main_encoder_buffer( 10, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_video_main_encoder_buffer_CH11( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_main_encoder_buffer( 11, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_video_main_encoder_buffer_CH12( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_main_encoder_buffer( 12, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_video_main_encoder_buffer_CH13( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_main_encoder_buffer( 13, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_video_main_encoder_buffer_CH14( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_main_encoder_buffer( 14, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_video_main_encoder_buffer_CH15( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_main_encoder_buffer( 15, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_video_main_encoder_buffer_CH16( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_main_encoder_buffer( 16, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

PF_BUFFER_CALLBACK g_on_video_main_compress_callback[ 16 ] = 
{  
	on_process_video_main_encoder_buffer_CH01, on_process_video_main_encoder_buffer_CH02, on_process_video_main_encoder_buffer_CH03, on_process_video_main_encoder_buffer_CH04, 
	on_process_video_main_encoder_buffer_CH05, on_process_video_main_encoder_buffer_CH06, on_process_video_main_encoder_buffer_CH07, on_process_video_main_encoder_buffer_CH08,
	on_process_video_main_encoder_buffer_CH09, on_process_video_main_encoder_buffer_CH10, on_process_video_main_encoder_buffer_CH11, on_process_video_main_encoder_buffer_CH12, 
	on_process_video_main_encoder_buffer_CH13, on_process_video_main_encoder_buffer_CH14, on_process_video_main_encoder_buffer_CH15,  on_process_video_main_encoder_buffer_CH16,
};

BOOL on_process_video_sub_encoder_buffer_CH01( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_sub_encoder_buffer( 1, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_video_sub_encoder_buffer_CH02( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_sub_encoder_buffer( 2, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_video_sub_encoder_buffer_CH03( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_sub_encoder_buffer( 3, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_video_sub_encoder_buffer_CH04( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_sub_encoder_buffer( 4, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_video_sub_encoder_buffer_CH05( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_sub_encoder_buffer( 5, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_video_sub_encoder_buffer_CH06( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_sub_encoder_buffer( 6, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_video_sub_encoder_buffer_CH07( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_sub_encoder_buffer( 7, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_video_sub_encoder_buffer_CH08( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_sub_encoder_buffer( 8, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_video_sub_encoder_buffer_CH09( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_sub_encoder_buffer(  9, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_video_sub_encoder_buffer_CH10( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_sub_encoder_buffer( 10, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_video_sub_encoder_buffer_CH11( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_sub_encoder_buffer( 11, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_video_sub_encoder_buffer_CH12( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_sub_encoder_buffer( 12, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_video_sub_encoder_buffer_CH13( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_sub_encoder_buffer( 13, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_video_sub_encoder_buffer_CH14( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_sub_encoder_buffer( 14, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_video_sub_encoder_buffer_CH15( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_sub_encoder_buffer( 15, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_video_sub_encoder_buffer_CH16( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_sub_encoder_buffer( 16, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

PF_BUFFER_CALLBACK g_on_video_sub_compress_callback[ 16 ] = 
{  
	on_process_video_sub_encoder_buffer_CH01, on_process_video_sub_encoder_buffer_CH02, on_process_video_sub_encoder_buffer_CH03, on_process_video_sub_encoder_buffer_CH04, 
	on_process_video_sub_encoder_buffer_CH05, on_process_video_sub_encoder_buffer_CH06, on_process_video_sub_encoder_buffer_CH07, on_process_video_sub_encoder_buffer_CH08,
	on_process_video_sub_encoder_buffer_CH09, on_process_video_sub_encoder_buffer_CH10, on_process_video_sub_encoder_buffer_CH11, on_process_video_sub_encoder_buffer_CH12, 
	on_process_video_sub_encoder_buffer_CH13, on_process_video_sub_encoder_buffer_CH14, on_process_video_sub_encoder_buffer_CH15,  on_process_video_sub_encoder_buffer_CH16,
};


CFileRenderer::CFileRenderer()
{
	m_bIsValid											= FALSE;	

	m_bIsRecording									= FALSE;

	m_bIsSchedule									= FALSE;

	m_hWnd												= NULL;

	m_nVideoStandard								= VIDEO_NTSC;

	m_nMainFileRendererRecordState		= 0x00000000;

	m_nSubFileRendererRecordState			= 0x00000000;

	m_hMainFileRendererDev			= 0xFFFFFFFF;	

	m_hSubFileRendererDev				= 0xFFFFFFFF;

	m_hVideoDev								= 0xFFFFFFFF;

	m_hVideoSwEncoderDev			= 0xFFFFFFFF;

	m_hVideoMainEncoderDev		= 0xFFFFFFFF;

	m_hVideoSubEncoderDev			= 0xFFFFFFFF;

	m_hAudioDev								= 0xFFFFFFFF;

	m_hAudioSwEncoderDev			= 0xFFFFFFFF;

	m_nNO										= 0;

	m_nCH										= 0;

	m_nVideoColorSapce					= 0;

	m_nVideoBitCount						= 0;

	m_nVideoEncoderType				= VIDEO_FORMAT_H264;

	m_nAudioEncoderType				= AUDIO_FORMAT_AAC;

	m_nFileType								= FILE_FORMAT_MP4;

	m_nMainFrameWidth					= 1920;

	m_nMainFrameHeight					= 1080;

	m_nMainDeinterlace					= 0;

	m_nMainFrameRate						= 29.97;

	m_nMainRecordMode					= RECORD_MODE_VBR;

	m_nMainBitRate							= 4 * 1024 * 1024;

	m_nMainQuality							= 8000;

	m_nMainGOP								= 30;

	m_nMainBFrame							= 0;
	
	m_nSubFrameWidth					= 1920;

	m_nSubFrameHeight					= 1080;

	m_nSubDeinterlace						= 0;

	m_nSubFrameRate						= 29.97;

	m_nSubRecordMode					= RECORD_MODE_VBR;

	m_nSubBitRate							= 4 * 1024 * 1024;

	m_nSubQuality							= 8000;

	m_nSubGOP								= 30;

	m_nSubBFrame							= 0;	

	ULONG nQuality = 10000;

	for ( ULONG i = 0 ; i < 21 ; i++ )
	{
		m_nMainQualityMatrix[ i ] = nQuality;

		m_nSubQualityMatrix[ i ] = nQuality;

		nQuality -= 500;
	}

	m_nMainBitRateMatrix[ 0 ] = 12288 * 1024; m_nSubBitRateMatrix[ 0 ] = 12288 * 1024;

	m_nMainBitRateMatrix[ 1 ] = 10240 * 1024; m_nSubBitRateMatrix[ 1 ] = 10240 * 1024;

	m_nMainBitRateMatrix[ 2 ] = 8192 * 1024; m_nSubBitRateMatrix[ 2 ] = 8192 * 1024;

	m_nMainBitRateMatrix[ 3 ] = 6144 * 1024; m_nSubBitRateMatrix[ 3 ] = 6144 * 1024;
	 
	m_nMainBitRateMatrix[ 4 ] = 4096 * 1024; m_nSubBitRateMatrix[ 4 ] = 4096 * 1024;

	m_nMainBitRateMatrix[ 5 ] = 3072 * 1024; m_nSubBitRateMatrix[ 5 ] = 3072 * 1024;

	m_nMainBitRateMatrix[ 6 ] = 2048 * 1024; m_nSubBitRateMatrix[ 6 ] = 2048 * 1024;

	m_nMainBitRateMatrix[ 7 ] = 1536 * 1024; m_nSubBitRateMatrix[ 7 ] = 1536 * 1024;

	m_nMainBitRateMatrix[ 8 ] = 1024 * 1024; m_nSubBitRateMatrix[ 8 ] = 1024 * 1024;

	m_nMainBitRateMatrix[ 9 ] = 768 * 1024; m_nSubBitRateMatrix[ 9 ] = 768 * 1024;

	m_nMainBitRateMatrix[ 10 ] = 512 * 1024; m_nSubBitRateMatrix[ 10 ] = 512 * 1024;

	m_nMainBitRateMatrix[ 11 ] = 256 * 1024; m_nSubBitRateMatrix[ 11 ] = 256 * 1024;

	m_nMainBitRateMatrix[ 12 ] = 128 * 1024; m_nSubBitRateMatrix[ 12 ] = 128 * 1024;

	m_nMainBitRateMatrix[ 13 ] = 64 * 1024; m_nSubBitRateMatrix[ 13 ] = 64 * 1024;

	InitializeCriticalSection( &m_hMainFileRendererChangeCriticalSection );

	InitializeCriticalSection( &m_hSubFileRendererChangeCriticalSection );
}

CFileRenderer::~CFileRenderer()
{	
	StopRecording();

	DeleteCriticalSection( &m_hMainFileRendererChangeCriticalSection );

	DeleteCriticalSection( &m_hSubFileRendererChangeCriticalSection );
}

BOOL CFileRenderer::IsValid()
{
	if (m_bIsValid <= 0 || m_bIsValid > 1) return FALSE;

	return TRUE;
}

BOOL CFileRenderer::StartRecording()
{
	if ( m_bIsRecording ) return FALSE;

	m_nNO = m_nCH;
	
# if ( SC540 == 1 )
	if (  m_strChipName == "QP0203 PCI" || m_strChipName == "TW6802 PCI" || m_strChipName == "SA7160 PCI" || m_strChipName == "CX2581 PCI" )
#else
	if ( m_strChipName == "TW6802 PCI" || m_strChipName == "SA7160 PCI" || m_strChipName == "CX2581 PCI" )
#endif	
	{	
		m_nVideoColorSapce = MAKEFOURCC('Y', 'U', 'Y', '2');

		m_nVideoBitCount = 16;

		m_hVideoDev = AMESDK_CREATE_EX( m_strChipName.GetBuffer( 256 ), m_nCH, 0,  NULL, g_on_live_video_callback[ m_nCH ], FALSE, TRUE, FALSE, this );	

		if ( m_nVideoEncoderType == VIDEO_FORMAT_H265 )
		{

# if ( USE_INTEL_ENCODE == 1 )
			m_hVideoSwEncoderDev = AMESDK_CREATE( "Common Analog Intel Encoder (H.265)", m_nCH, 7, NULL, NULL, NULL );
#else
			m_hVideoSwEncoderDev = AMESDK_CREATE( "Common Analog Encoder (H.265)", m_nCH, 7, NULL, NULL, NULL );	
#endif

			AMESDK_SET_FORMAT( m_hVideoSwEncoderDev, MAKEFOURCC('H', '2', '6', '5'), m_nMainFrameWidth, m_nMainFrameHeight, 24, m_nMainFrameRate, m_nMainRecordMode, m_nMainBitRate, m_nMainQuality, m_nMainGOP, m_nMainDeinterlace, 0 ); 
		}
		else
		{

# if ( USE_INTEL_ENCODE == 1 )
			m_hVideoSwEncoderDev = AMESDK_CREATE( "Common Analog Intel Encoder (H.264)", m_nCH, 7, NULL, NULL, NULL );
#else
			m_hVideoSwEncoderDev = AMESDK_CREATE( "Common Analog Encoder (H.264)", m_nCH, 7, NULL, NULL, NULL );	
#endif

			AMESDK_SET_FORMAT( m_hVideoSwEncoderDev, MAKEFOURCC('H', '2', '6', '4'), m_nMainFrameWidth, m_nMainFrameHeight, 24, m_nMainFrameRate, m_nMainRecordMode, m_nMainBitRate, m_nMainQuality, m_nMainGOP, m_nMainDeinterlace, 0 ); 
		}		

		CHAR pszFilePathName[ MAX_PATH ];

		CString strFile; GetRecordingFilePathName( FALSE, strFile );

		lstrcpy( pszFilePathName, strFile );

		m_hMainFileRendererDev = AMESDK_CREATE( pszFilePathName, m_nNO, 3, NULL, NULL, NULL );

		if( m_hMainFileRendererDev & 0x80000000 ) { m_hMainFileRendererDev = 0xFFFFFFFF; }

		if ( m_nVideoEncoderType == VIDEO_FORMAT_H265 )
			AMESDK_FILE_SET_VIDEO_STREAM_FORMAT( m_hMainFileRendererDev, MAKEFOURCC('H', '2', '6', '5'), m_nMainFrameWidth, m_nMainFrameHeight, 24, m_nMainFrameRate, 0x00000000 );
		else
			AMESDK_FILE_SET_VIDEO_STREAM_FORMAT( m_hMainFileRendererDev, MAKEFOURCC('H', '2', '6', '4'), m_nMainFrameWidth, m_nMainFrameHeight, 24, m_nMainFrameRate, 0x00000000 );	
	}
	else
	// if ( m_strChipName == "AH8400 PCI" || m_strChipName == "FH8735 PCI" || m_strChipName == "TW5864 PCI" || m_strChipName == "TW2809 PCI" || m_strChipName == "MZ0308 PCI"  || m_strChipName == "QP0203 PCI"  )
	{
		m_nVideoColorSapce = MAKEFOURCC('Y', 'V', '1', '2');

		m_nVideoBitCount = 12;

		m_hVideoDev = AMESDK_CREATE( m_strChipName.GetBuffer( 256 ), m_nCH, 0, NULL, g_on_live_video_callback[ m_nCH ], this );

		CString strMainChipName = m_strChipName + ", Analog Encoder";

		m_hVideoMainEncoderDev = AMESDK_CREATE( strMainChipName.GetBuffer( 256 ), m_nCH, 0, NULL, g_on_video_main_compress_callback[ m_nCH ], this );

		strMainChipName.ReleaseBuffer();

		if( m_hVideoMainEncoderDev & 0x80000000 ) 
		{ 
			m_hVideoMainEncoderDev = 0xFFFFFFFF;
		}
		else
		{
			AMESDK_SET_STANDARD( m_nVideoEncoderType, m_nVideoStandard ); 

			if ( m_nVideoEncoderType == VIDEO_FORMAT_H265 )
				AMESDK_SET_FORMAT( m_hVideoMainEncoderDev, MAKEFOURCC('H', '2', '6', '5'), m_nMainFrameWidth, m_nMainFrameHeight, 24, m_nMainFrameRate );
			else
				AMESDK_SET_FORMAT( m_hVideoMainEncoderDev, MAKEFOURCC('H', '2', '6', '4'), m_nMainFrameWidth, m_nMainFrameHeight, 24, m_nMainFrameRate );

			AMESDK_SET_DEINTERLACE( m_hVideoMainEncoderDev, m_nMainDeinterlace );

			AMESDK_SET_VIDEOCOMPRESSION_PROPERTY( m_hVideoMainEncoderDev, 0x00000003, m_nMainRecordMode );

			AMESDK_SET_VIDEOCOMPRESSION_PROPERTY( m_hVideoMainEncoderDev, 0x00000001, m_nMainQuality );

			AMESDK_SET_VIDEOCOMPRESSION_PROPERTY( m_hVideoMainEncoderDev, 0x00000004, m_nMainBitRate );

			AMESDK_SET_VIDEOCOMPRESSION_PROPERTY( m_hVideoMainEncoderDev, 0x00000000, m_nMainGOP );

			AMESDK_SET_VIDEOCOMPRESSION_PROPERTY( m_hVideoMainEncoderDev, 0x0000000A, m_nMainBFrame );

			CHAR pszFilePathName[ MAX_PATH ];

			CString strFile; GetRecordingFilePathName( FALSE, strFile );

			lstrcpy( pszFilePathName, strFile );

			m_hMainFileRendererDev = AMESDK_CREATE( pszFilePathName, m_nNO, 3, NULL, NULL, NULL );

			if( m_hMainFileRendererDev & 0x80000000 ) { m_hMainFileRendererDev = 0xFFFFFFFF; }

			if ( m_nVideoEncoderType == VIDEO_FORMAT_H265 )
				AMESDK_FILE_SET_VIDEO_STREAM_FORMAT( m_hMainFileRendererDev, MAKEFOURCC('H', '2', '6', '5'), m_nMainFrameWidth, m_nMainFrameHeight, 24, m_nMainFrameRate, 0x00000000 );
			else
				AMESDK_FILE_SET_VIDEO_STREAM_FORMAT( m_hMainFileRendererDev, MAKEFOURCC('H', '2', '6', '4'), m_nMainFrameWidth, m_nMainFrameHeight, 24, m_nMainFrameRate, 0x00000000 );	
		}

		if ( m_strChipName == "FH8735 PCI" || m_strChipName == "TW2809 PCI" || m_strChipName == "TW5864 PCI" )
		{
			CString strSubChipName = m_strChipName + ", Analog Encoder";

			m_hVideoSubEncoderDev = AMESDK_CREATE( strSubChipName.GetBuffer( 256 ), m_nCH, 0, NULL, g_on_video_sub_compress_callback[ m_nCH ], this );

			strSubChipName.ReleaseBuffer();

			if( m_hVideoSubEncoderDev & 0x80000000 ) 
			{ 
				m_hVideoSubEncoderDev = 0xFFFFFFFF;
			}
			else
			{
				AMESDK_SET_STANDARD( m_hVideoSubEncoderDev, m_nVideoStandard ); 

				AMESDK_SET_DEINTERLACE( m_hVideoSubEncoderDev, m_nMainDeinterlace );

				if ( m_nVideoEncoderType == VIDEO_FORMAT_H265 )
					AMESDK_SET_FORMAT( m_hVideoSubEncoderDev, MAKEFOURCC('X', '2', '6', '5'), m_nSubFrameWidth, m_nSubFrameHeight, 24, m_nSubFrameRate );
				else
					AMESDK_SET_FORMAT( m_hVideoSubEncoderDev, MAKEFOURCC('X', '2', '6', '4'), m_nSubFrameWidth, m_nSubFrameHeight, 24, m_nSubFrameRate );

				AMESDK_SET_VIDEOCOMPRESSION_PROPERTY( m_hVideoSubEncoderDev, 0x00000003, m_nSubRecordMode );

				AMESDK_SET_VIDEOCOMPRESSION_PROPERTY( m_hVideoSubEncoderDev, 0x00000001, m_nSubQuality );

				AMESDK_SET_VIDEOCOMPRESSION_PROPERTY( m_hVideoSubEncoderDev, 0x00000004, m_nSubBitRate );

				AMESDK_SET_VIDEOCOMPRESSION_PROPERTY( m_hVideoSubEncoderDev, 0x00000000, m_nSubGOP );

				AMESDK_SET_VIDEOCOMPRESSION_PROPERTY( m_hVideoSubEncoderDev, 0x0000000A, m_nSubBFrame );

				CHAR pszFilePathName[ MAX_PATH ];

				CString strFile; GetRecordingFilePathName( TRUE, strFile );

				lstrcpy( pszFilePathName, strFile );

				m_nNO++;

				m_hSubFileRendererDev = AMESDK_CREATE( pszFilePathName, m_nNO, 3, NULL, NULL, NULL );

				if( m_hSubFileRendererDev & 0x80000000 ) { m_hSubFileRendererDev = 0xFFFFFFFF; }

				if ( m_nVideoEncoderType == VIDEO_FORMAT_H265 )
					AMESDK_FILE_SET_VIDEO_STREAM_FORMAT( m_hSubFileRendererDev, MAKEFOURCC('H', '2', '6', '5'), m_nSubFrameWidth, m_nSubFrameHeight, 24, m_nSubFrameRate, 0x00000000 );
				else
					AMESDK_FILE_SET_VIDEO_STREAM_FORMAT( m_hSubFileRendererDev, MAKEFOURCC('H', '2', '6', '4'), m_nSubFrameWidth, m_nSubFrameHeight, 24, m_nSubFrameRate, 0x00000000 );	
			}
		}		
	}

	m_strChipName.ReleaseBuffer();

	if( m_hVideoDev & 0x80000000 ) 
	{ 
		m_hVideoDev = 0xFFFFFFFF;		
	}		

	CString strAudioChipName = m_strChipName + ", Analog WaveIn";

	m_hAudioDev = AMESDK_CREATE( strAudioChipName.GetBuffer( 256 ), m_nCH, 0, m_hWnd, g_on_live_audio_callback[ m_nCH ], this );

	strAudioChipName.ReleaseBuffer();

	if( m_hAudioDev & 0x80000000 ) 
	{ 
		m_hAudioDev = 0xFFFFFFFF;	
	}

	if ( m_nAudioEncoderType == AUDIO_FORMAT_AAC )
	{
		m_hAudioSwEncoderDev = AMESDK_CREATE( "Common Analog Encoder (AAC)", m_nCH, 7, NULL, NULL, NULL );
	}

	if ( m_nAudioEncoderType == AUDIO_FORMAT_AAC_ADTS )
	{
		m_hAudioSwEncoderDev = AMESDK_CREATE( "Common Analog Encoder (AAC.ADTS)", m_nCH, 7, NULL, NULL, NULL );
	}

	if ( m_nAudioEncoderType == AUDIO_FORMAT_MP2 )
	{
		m_hAudioSwEncoderDev = AMESDK_CREATE( "Common Analog Encoder (MP2)", m_nCH, 7, NULL, NULL, NULL );
	}

	if ( m_nAudioEncoderType == AUDIO_FORMAT_MP3 )
	{
		m_hAudioSwEncoderDev = AMESDK_CREATE( "Common Analog Encoder (MP3)", m_nCH, 7, NULL, NULL, NULL );
	}

	if ( m_nAudioEncoderType == AUDIO_FORMAT_OPUS )
	{
		m_hAudioSwEncoderDev = AMESDK_CREATE( "Common Analog Encoder (OPUS)", m_nCH, 7, NULL, NULL, NULL );
	}

	if( m_hAudioSwEncoderDev & 0x80000000 ) 
	{ 
		m_hAudioSwEncoderDev = 0xFFFFFFFF;	
	}	

	ULONG nChannels = 0;
	
	ULONG nBitsPerSample = 0; 
	
	ULONG nSamplesPerSec = 0;

	if ( m_strChipName.Find( "CX2581" ) != -1 )
	{
		AMESDK_SET_FORMAT( m_hAudioDev, 1, 8, 8000 );

		AMESDK_SET_FORMAT( m_hAudioSwEncoderDev, 1, 8, 8000 );

		nChannels = 1; nBitsPerSample = 8; nSamplesPerSec = 8000;
	}
	else if ( ( m_strChipName.Find( "AH8400" ) != -1 ) || ( m_strChipName.Find( "TW5864" ) != -1 ) )
	{
		AMESDK_SET_FORMAT( m_hAudioDev, 1, 16, 8000 );

		AMESDK_SET_FORMAT( m_hAudioSwEncoderDev, 1, 16, 8000 );		

		nChannels = 1; nBitsPerSample = 16; nSamplesPerSec = 8000;
	}
	else
	{
		AMESDK_SET_FORMAT( m_hAudioDev, 2, 16, 48000 );

		AMESDK_SET_FORMAT( m_hAudioSwEncoderDev, 2, 16, 48000 );

		nChannels = 2; nBitsPerSample = 16; nSamplesPerSec = 48000;
	}	

	AMESDK_SET_VOLUME( m_hAudioDev, 0 );

	// 0x00000000: PCM , 0x00000001: AAC RAW , 0x00000002: AAC ADTS , 0x00000004: MP2 , 0x00000005: MP3 , 0x00000006: OPUS
	//
	if ( m_nAudioEncoderType == AUDIO_FORMAT_PCM )
	{
		AMESDK_FILE_SET_AUDIO_STREAM_FORMAT( m_hMainFileRendererDev, 0x00000000, nChannels, nBitsPerSample, nSamplesPerSec );

		//AMESDK_FILE_SET_AUDIO_STREAM_FORMAT( m_hSubFileRendererDev, 0x00000000, nChannels, nBitsPerSample, nSamplesPerSec );
	}

	if ( m_nAudioEncoderType == AUDIO_FORMAT_AAC )
	{
		AMESDK_FILE_SET_AUDIO_STREAM_FORMAT( m_hMainFileRendererDev, 0x00000001, nChannels, nBitsPerSample, nSamplesPerSec );

		//AMESDK_FILE_SET_AUDIO_STREAM_FORMAT( m_hSubFileRendererDev, 0x00000001, nChannels, nBitsPerSample, nSamplesPerSec );
	}

	if ( m_nAudioEncoderType == AUDIO_FORMAT_AAC_ADTS )
	{
		AMESDK_FILE_SET_AUDIO_STREAM_FORMAT( m_hMainFileRendererDev, 0x00000002, nChannels, nBitsPerSample, nSamplesPerSec );

		//AMESDK_FILE_SET_AUDIO_STREAM_FORMAT( m_hSubFileRendererDev, 0x00000002, nChannels, nBitsPerSample, nSamplesPerSec );
	}

	if ( m_nAudioEncoderType == AUDIO_FORMAT_MP2 )
	{
		AMESDK_FILE_SET_AUDIO_STREAM_FORMAT( m_hMainFileRendererDev, 0x00000004, nChannels, nBitsPerSample, nSamplesPerSec );

		//AMESDK_FILE_SET_AUDIO_STREAM_FORMAT( m_hSubFileRendererDev, 0x00000004, nChannels, nBitsPerSample, nSamplesPerSec );
	}

	if ( m_nAudioEncoderType == AUDIO_FORMAT_MP3 )
	{
		AMESDK_FILE_SET_AUDIO_STREAM_FORMAT( m_hMainFileRendererDev, 0x00000005, nChannels, nBitsPerSample, nSamplesPerSec );

		//AMESDK_FILE_SET_AUDIO_STREAM_FORMAT( m_hSubFileRendererDev, 0x00000005, nChannels, nBitsPerSample, nSamplesPerSec );
	}

	if ( m_nAudioEncoderType == AUDIO_FORMAT_OPUS )
	{
		AMESDK_FILE_SET_AUDIO_STREAM_FORMAT( m_hMainFileRendererDev, 0x00000006, nChannels, nBitsPerSample, nSamplesPerSec );

		//AMESDK_FILE_SET_AUDIO_STREAM_FORMAT( m_hSubFileRendererDev, 0x00000006, nChannels, nBitsPerSample, nSamplesPerSec );
	}	

	AMESDK_SET_STANDARD( m_hVideoDev, m_nVideoStandard );

	AMESDK_SET_FORMAT( m_hVideoDev, m_nVideoColorSapce, m_nMainFrameWidth, m_nMainFrameHeight, m_nVideoBitCount, m_nMainFrameRate );

	AMESDK_SET_DEINTERLACE( m_hVideoDev, m_nMainDeinterlace );

	AMESDK_RUN( m_hVideoDev );

	AMESDK_RUN( m_hVideoSwEncoderDev );

	AMESDK_RUN( m_hVideoMainEncoderDev );

	//AMESDK_RUN( m_hVideoSubEncoderDev );

	AMESDK_RUN( m_hAudioDev );

	AMESDK_RUN( m_hAudioSwEncoderDev );
	
	// Sleep( 512 );

	m_nMainFileRendererRecordState = 0x00000001;

	m_nSubFileRendererRecordState = 0x00000001;

	m_bIsRecording = TRUE;	

	return TRUE;
}

BOOL CFileRenderer::StopRecording()
{
	m_nMainFileRendererRecordState = 0x00000000;

	m_nSubFileRendererRecordState = 0x00000000;

	m_bIsRecording = FALSE;	

	Sleep( 512 );

	if( m_hVideoMainEncoderDev != 0xFFFFFFFF ) { AMESDK_STOP( m_hVideoMainEncoderDev );  AMESDK_DESTROY( m_hVideoMainEncoderDev ); m_hVideoMainEncoderDev = 0xFFFFFFFF; }	

	if( m_hVideoDev != 0xFFFFFFFF ) { AMESDK_STOP( m_hVideoDev ); AMESDK_DESTROY( m_hVideoDev ); m_hVideoDev = 0xFFFFFFFF; }

	if( m_hAudioDev != 0xFFFFFFFF ) { AMESDK_STOP( m_hAudioDev );  AMESDK_DESTROY( m_hAudioDev ); m_hAudioDev = 0xFFFFFFFF; }	

	if( m_hVideoSwEncoderDev != 0xFFFFFFFF ) { AMESDK_STOP( m_hVideoSwEncoderDev );  AMESDK_DESTROY( m_hVideoSwEncoderDev ); m_hVideoSwEncoderDev = 0xFFFFFFFF; }		

	if( m_hAudioSwEncoderDev != 0xFFFFFFFF ) { AMESDK_STOP( m_hAudioSwEncoderDev );  AMESDK_DESTROY( m_hAudioSwEncoderDev ); m_hAudioSwEncoderDev = 0xFFFFFFFF; }		

	if( m_hMainFileRendererDev != 0xFFFFFFFF ) { AMESDK_STOP( m_hMainFileRendererDev );  AMESDK_DESTROY( m_hMainFileRendererDev ); m_hMainFileRendererDev = 0xFFFFFFFF; }	

	return TRUE;
}

CString CFileRenderer::GetWorkingPath()
{
	TCHAR szCurPath[MAX_PATH] = {0};

	GetModuleFileName(NULL, szCurPath, MAX_PATH);

	CString strCurPath = szCurPath;

	strCurPath = strCurPath.Left(strCurPath.ReverseFind('\\') + 1);

	return strCurPath;
}

void CFileRenderer::GetRecordingFilePathName( BOOL bIsSubStream, CString & strFile )
{
	CHAR pszFilePathName[ MAX_PATH ];

	CHAR pszVideoEncoder[ 10 ];

	CHAR pszAudioEncoder[ 10 ];

	CHAR pszFileType[ 10 ];

	if ( m_nVideoEncoderType == VIDEO_FORMAT_H265  )
		sprintf( pszVideoEncoder, "%s", "H265" );
	else
		sprintf( pszVideoEncoder, "%s", "H264" );

	if ( m_nAudioEncoderType == AUDIO_FORMAT_PCM  )
		sprintf( pszAudioEncoder, "%s", "PCM" );
	else if ( m_nAudioEncoderType == AUDIO_FORMAT_AAC  )
		sprintf( pszAudioEncoder, "%s", "AAC" );
	else if ( m_nAudioEncoderType == AUDIO_FORMAT_AAC_ADTS  )
		sprintf( pszAudioEncoder, "%s", "AAC_ADTS" );
	else if ( m_nAudioEncoderType == AUDIO_FORMAT_MP2  )
		sprintf( pszAudioEncoder, "%s", "MP2" );
	else if ( m_nAudioEncoderType == AUDIO_FORMAT_MP3  )
		sprintf( pszAudioEncoder, "%s", "MP3" );
	else if ( m_nAudioEncoderType == AUDIO_FORMAT_OPUS  )
		sprintf( pszAudioEncoder, "%s", "OPUS" );

	if ( m_nFileType == FILE_FORMAT_MP4  )
		sprintf( pszFileType, "%s", "MP4" );
	else if ( m_nFileType == FILE_FORMAT_TS  )
		sprintf( pszFileType, "%s", "TS" );
	else if ( m_nFileType == FILE_FORMAT_ASF  )
		sprintf( pszFileType, "%s", "ASF" );
	else if ( m_nFileType == FILE_FORMAT_WMV  )
		sprintf( pszFileType, "%s", "WMV" );
	else if ( m_nFileType == FILE_FORMAT_FLV  )
		sprintf( pszFileType, "%s", "FLV" );

	SYSTEMTIME sCurrSystemTimes;  GetLocalTime( &sCurrSystemTimes );

	if ( bIsSubStream ) 
	{ 
		if ( m_bIsSchedule )
		{
			sprintf( pszFilePathName, "Common Analog File Renderer %sCH%02d_SUB_%dX%d_%s_%s_%04d.%02d.%02d_%02d.%02d.%02d.%s", GetWorkingPath() + "SCHEDULE.RECORDING\\", m_nCH + 1, m_nSubFrameWidth , m_nSubFrameHeight, pszVideoEncoder,  pszAudioEncoder, sCurrSystemTimes.wYear, sCurrSystemTimes.wMonth, sCurrSystemTimes.wDay, sCurrSystemTimes.wHour, sCurrSystemTimes.wMinute, sCurrSystemTimes.wSecond, pszFileType ); 
		}
		else
		{
			sprintf( pszFilePathName, "Common Analog File Renderer %sCH%02d_SUB_%dX%d_%s_%s.%s", GetWorkingPath(), m_nCH + 1, m_nSubFrameWidth , m_nSubFrameHeight, pszVideoEncoder,  pszAudioEncoder, pszFileType ); 
		}
	} 
	else
	{
		if ( m_bIsSchedule )
		{
			sprintf( pszFilePathName, "Common Analog File Renderer %sCH%02d_%dX%d_%s_%s_%04d.%02d.%02d_%02d.%02d.%02d.%s", GetWorkingPath() + "SCHEDULE.RECORDING\\", m_nCH + 1,  m_nMainFrameWidth , m_nMainFrameHeight, pszVideoEncoder,  pszAudioEncoder, sCurrSystemTimes.wYear, sCurrSystemTimes.wMonth, sCurrSystemTimes.wDay, sCurrSystemTimes.wHour, sCurrSystemTimes.wMinute, sCurrSystemTimes.wSecond, pszFileType ); 
		}
		else
		{
			sprintf( pszFilePathName, "Common Analog File Renderer %sCH%02d_%dX%d_%s_%s.%s", GetWorkingPath(), m_nCH + 1, m_nMainFrameWidth , m_nMainFrameHeight, pszVideoEncoder,  pszAudioEncoder, pszFileType ); 
		}
	}

	strFile = pszFilePathName;	
}